// David Eberly, Geometric Tools, Redmond WA 98052
// Copyright (c) 1998-2025
// Distributed under the Boost Software License, Version 1.0.
// https://www.boost.org/LICENSE_1_0.txt
// https://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
// File Version: 8.0.2025.05.10

#pragma once

#include <Applications/Window3.h>
using namespace gte;

// Enable only one of these.
#define GENERATE_MESH_UVS_CPU_SINGLE_THREADED
//#define GENERATE_MESH_UVS_CPU_MULTITHREADED
//#define GENERATE_MESH_UVS_GPU

class GenerateMeshUVsWindow3 : public Window3
{
public:
    GenerateMeshUVsWindow3(Parameters& parameters);

    virtual void OnIdle() override;
    virtual bool OnCharPress(uint8_t key, int32_t x, int32_t y) override;

private:
    bool SetEnvironment();
    void CreateScene();
    void CreateMeshOriginal();

    // The texture is applied differently for the resampled mesh, because
    // the original has texture coordinates generated by the mesh factory
    // (based on polar coordinates).  The resampled mesh has texture
    // coordinates generated by barycentric mapping.  The orientation of
    // the texture depends on how the mesh boundary is mapped to the
    // uv-square.
    void CreateMeshResampled();

    struct Vertex
    {
        Vector3<float> position;
        Vector2<float> tcoord;
    };

    std::shared_ptr<Visual> mMeshOriginal, mMeshResampled;
    std::shared_ptr<RasterizerState> mNoCullState;
    std::shared_ptr<RasterizerState> mNoCullWireState;
    bool mDrawMeshOriginal;
};

