// David Eberly, Geometric Tools, Redmond WA 98052
// Copyright (c) 1998-2025
// Distributed under the Boost Software License, Version 1.0.
// https://www.boost.org/LICENSE_1_0.txt
// https://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
// File Version: 8.0.2025.05.10

#include <Graphics/GTGraphicsPCH.h>
#include <Graphics/FontArialW700H12.h>
using namespace gte;

FontArialW700H12::FontArialW700H12(std::shared_ptr<ProgramFactory> const& factory, int32_t maxMessageLength)
    :
    Font(factory, msWidth, msHeight, reinterpret_cast<uint8_t const*>(msTexels), msCharacterData, maxMessageLength)
{
}

int32_t FontArialW700H12::msWidth = 1868;
int32_t FontArialW700H12::msHeight = 12;

uint8_t FontArialW700H12::msTexels[22416] =
{
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255,   0, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0,   0, 255,   0,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
  0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0,   0,   0, 
  0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255,   0,   0, 255,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
  0, 255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
  0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 
  0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255,   0, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255,   0, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
  0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 
  0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 
  0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0, 
  0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
  0,   0, 255, 255, 255,   0,   0,   0, 255,   0, 255,   0,   0,   0, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255,   0, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255,   0, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
  0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
  0, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255,   0, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
  0, 255,   0,   0,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 
255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0, 255, 
  0, 255, 255, 255,   0, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
  0, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255,   0, 255, 255, 
  0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
  0, 255, 255,   0,   0,   0,   0,   0,   0, 255,   0, 255,   0, 255, 255, 255, 
255,   0, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255,   0,   0,   0,   0,   0, 255,   0, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255,   0,   0,   0, 255, 
255, 255,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255,   0,   0,   0, 255,   0,   0, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255,   0,   0,   0, 255, 255, 255,   0, 
  0,   0,   0, 255,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 
  0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0,   0, 255, 255,   0, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0,   0,   0, 255,   0, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0,   0,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255,   0, 255,   0, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255,   0,   0,   0, 255,   0,   0,   0, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255,   0, 255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 255,   0, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0,   0,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
  0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 
255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0,   0, 
  0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0,   0, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255,   0, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
  0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255,   0,   0,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0,   0, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255,   0, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255,   0, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 
  0,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
  0,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255,   0, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255,   0, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 

};

float FontArialW700H12::msCharacterData[257] =
{
0.000268f, 0.005086f, 0.009904f, 0.014722f, 0.019540f, 0.024358f, 0.029176f, 0.033994f, 
0.038812f, 0.043630f, 0.048448f, 0.053266f, 0.058084f, 0.062901f, 0.067719f, 0.072537f, 
0.077355f, 0.082173f, 0.086991f, 0.091809f, 0.096627f, 0.101445f, 0.106263f, 0.111081f, 
0.115899f, 0.120717f, 0.125535f, 0.130353f, 0.135171f, 0.139989f, 0.144807f, 0.149625f, 
0.154443f, 0.156585f, 0.158726f, 0.161938f, 0.165685f, 0.169433f, 0.174786f, 0.179069f, 
0.180675f, 0.182816f, 0.184957f, 0.187634f, 0.191381f, 0.193522f, 0.195664f, 0.197805f, 
0.199946f, 0.203694f, 0.207441f, 0.211188f, 0.214936f, 0.218683f, 0.222430f, 0.226178f, 
0.229925f, 0.233672f, 0.237420f, 0.239561f, 0.241702f, 0.245450f, 0.249197f, 0.252944f, 
0.256692f, 0.262580f, 0.266863f, 0.271146f, 0.275428f, 0.279711f, 0.283994f, 0.287741f, 
0.292559f, 0.296842f, 0.298983f, 0.302730f, 0.307013f, 0.310760f, 0.316113f, 0.320396f, 
0.325214f, 0.329497f, 0.334315f, 0.338597f, 0.342880f, 0.346092f, 0.350375f, 0.354657f, 
0.360011f, 0.364293f, 0.368576f, 0.372323f, 0.374465f, 0.376606f, 0.378747f, 0.382495f, 
0.386242f, 0.388383f, 0.392131f, 0.395878f, 0.399625f, 0.403373f, 0.407120f, 0.409261f, 
0.413009f, 0.416756f, 0.418897f, 0.421574f, 0.425321f, 0.427463f, 0.432816f, 0.436563f, 
0.440310f, 0.444058f, 0.447805f, 0.450482f, 0.454229f, 0.456370f, 0.460118f, 0.464400f, 
0.469754f, 0.473501f, 0.476713f, 0.479925f, 0.482602f, 0.484743f, 0.487420f, 0.491167f, 
0.495985f, 0.500803f, 0.505621f, 0.510439f, 0.515257f, 0.520075f, 0.524893f, 0.529711f, 
0.534529f, 0.539347f, 0.544165f, 0.548983f, 0.553801f, 0.558619f, 0.563437f, 0.568255f, 
0.573073f, 0.577891f, 0.582709f, 0.587527f, 0.592345f, 0.597163f, 0.601981f, 0.606799f, 
0.611617f, 0.616435f, 0.621253f, 0.626071f, 0.630889f, 0.635707f, 0.640525f, 0.645343f, 
0.650161f, 0.652302f, 0.654443f, 0.658191f, 0.661938f, 0.665685f, 0.669433f, 0.671574f, 
0.675321f, 0.677463f, 0.681745f, 0.684422f, 0.688169f, 0.691916f, 0.694058f, 0.698340f, 
0.702088f, 0.704764f, 0.707976f, 0.710118f, 0.712259f, 0.714400f, 0.718148f, 0.721895f, 
0.724036f, 0.726713f, 0.728854f, 0.731531f, 0.735278f, 0.740096f, 0.744914f, 0.749732f, 
0.753480f, 0.757762f, 0.762045f, 0.766328f, 0.770610f, 0.774893f, 0.779176f, 0.785064f, 
0.789347f, 0.793630f, 0.797912f, 0.802195f, 0.806477f, 0.808619f, 0.810760f, 0.812901f, 
0.815043f, 0.819325f, 0.823608f, 0.828426f, 0.833244f, 0.838062f, 0.842880f, 0.847698f, 
0.851445f, 0.856263f, 0.860546f, 0.864829f, 0.869111f, 0.873394f, 0.877677f, 0.881959f, 
0.885707f, 0.889454f, 0.893201f, 0.896949f, 0.900696f, 0.904443f, 0.908191f, 0.913544f, 
0.917291f, 0.921039f, 0.924786f, 0.928533f, 0.932280f, 0.934422f, 0.936563f, 0.938704f, 
0.940846f, 0.944593f, 0.948340f, 0.952088f, 0.955835f, 0.959582f, 0.963330f, 0.967077f, 
0.970289f, 0.974036f, 0.977784f, 0.981531f, 0.985278f, 0.989026f, 0.992773f, 0.996520f, 
1.000268f, 
};

