// David Eberly, Geometric Tools, Redmond WA 98052
// Copyright (c) 1998-2025
// Distributed under the Boost Software License, Version 1.0.
// https://www.boost.org/LICENSE_1_0.txt
// https://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
// File Version: 8.0.2025.05.10

#include <Graphics/GTGraphicsPCH.h>
#include <Graphics/FontArialW400H16.h>
using namespace gte;

FontArialW400H16::FontArialW400H16(std::shared_ptr<ProgramFactory> const& factory, int32_t maxMessageLength)
    :
    Font(factory, msWidth, msHeight, reinterpret_cast<uint8_t const*>(msTexels), msCharacterData, maxMessageLength)
{
}

int32_t FontArialW400H16::msWidth = 2238;
int32_t FontArialW400H16::msHeight = 16;

uint8_t FontArialW400H16::msTexels[35808] =
{
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
  0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
  0,   0, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 
255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
  0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255,   0, 255,   0,   0, 255, 255, 255, 255, 255,   0,   0, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
  0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0, 255,   0, 
255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0, 255,   0, 
255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0, 255,   0, 
255, 255, 255, 255,   0,   0,   0, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
  0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 
  0, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 
255,   0, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 
255,   0, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 
255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
  0, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255,   0, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 
255, 255,   0,   0, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
  0, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 
255,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
  0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0,   0, 
  0,   0, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 
  0, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0,   0,   0, 
  0,   0, 255, 255, 255,   0, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 
255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 
255, 255,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
255, 255,   0,   0, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255,   0, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255,   0, 255, 255,   0,   0, 
  0,   0,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0,   0,   0, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0,   0,   0, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255,   0, 255,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255, 
  0, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0,   0, 
255, 255,   0,   0, 255, 255, 255, 255,   0, 255,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0, 255,   0,   0, 255, 255, 255, 255, 
255,   0,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0,   0, 
  0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0,   0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255,   0,   0,   0, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255,   0, 255,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
  0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0, 
  0,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 
  0,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0,   0,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 
255, 255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 

};

float FontArialW400H16::msCharacterData[257] =
{
0.000223f, 0.005139f, 0.010054f, 0.014969f, 0.019884f, 0.024799f, 0.029714f, 0.034629f, 
0.039544f, 0.044459f, 0.049374f, 0.054290f, 0.059205f, 0.064120f, 0.069035f, 0.073950f, 
0.078865f, 0.083780f, 0.088695f, 0.093610f, 0.098525f, 0.103441f, 0.108356f, 0.113271f, 
0.118186f, 0.123101f, 0.128016f, 0.132931f, 0.137846f, 0.142761f, 0.147676f, 0.152592f, 
0.157507f, 0.159741f, 0.161528f, 0.164209f, 0.167784f, 0.171358f, 0.177167f, 0.181635f, 
0.182976f, 0.185210f, 0.187444f, 0.190125f, 0.194147f, 0.196381f, 0.198615f, 0.200849f, 
0.203083f, 0.206658f, 0.210232f, 0.213807f, 0.217382f, 0.220956f, 0.224531f, 0.228105f, 
0.231680f, 0.235255f, 0.238829f, 0.241063f, 0.243298f, 0.247319f, 0.251340f, 0.255362f, 
0.258937f, 0.265192f, 0.269660f, 0.274129f, 0.278597f, 0.283065f, 0.287534f, 0.291555f, 
0.296470f, 0.300938f, 0.302726f, 0.305853f, 0.310322f, 0.313896f, 0.319258f, 0.323727f, 
0.328642f, 0.333110f, 0.338025f, 0.342493f, 0.346962f, 0.350536f, 0.355004f, 0.359473f, 
0.365728f, 0.369303f, 0.373771f, 0.377346f, 0.379580f, 0.381814f, 0.384048f, 0.386729f, 
0.390304f, 0.392538f, 0.396113f, 0.399687f, 0.403262f, 0.406836f, 0.410411f, 0.412198f, 
0.415773f, 0.419348f, 0.421135f, 0.422922f, 0.426497f, 0.428284f, 0.433646f, 0.437221f, 
0.440795f, 0.444370f, 0.447945f, 0.450179f, 0.453753f, 0.455987f, 0.459562f, 0.462243f, 
0.466711f, 0.470286f, 0.473861f, 0.477435f, 0.479669f, 0.481457f, 0.483691f, 0.487712f, 
0.492627f, 0.497542f, 0.502458f, 0.507373f, 0.512288f, 0.517203f, 0.522118f, 0.527033f, 
0.531948f, 0.536863f, 0.541778f, 0.546694f, 0.551609f, 0.556524f, 0.561439f, 0.566354f, 
0.571269f, 0.576184f, 0.581099f, 0.586014f, 0.590929f, 0.595845f, 0.600760f, 0.605675f, 
0.610590f, 0.615505f, 0.620420f, 0.625335f, 0.630250f, 0.635165f, 0.640080f, 0.644996f, 
0.649911f, 0.652145f, 0.653932f, 0.657507f, 0.661081f, 0.664656f, 0.668231f, 0.670018f, 
0.673593f, 0.675827f, 0.680742f, 0.682976f, 0.686550f, 0.690572f, 0.692806f, 0.697721f, 
0.701296f, 0.703977f, 0.707551f, 0.709786f, 0.712020f, 0.714254f, 0.717828f, 0.721403f, 
0.723637f, 0.725871f, 0.728105f, 0.730786f, 0.734361f, 0.739723f, 0.745085f, 0.750447f, 
0.754468f, 0.758937f, 0.763405f, 0.767873f, 0.772341f, 0.776810f, 0.781278f, 0.787534f, 
0.792002f, 0.796470f, 0.800938f, 0.805407f, 0.809875f, 0.811662f, 0.813450f, 0.815237f, 
0.817024f, 0.821492f, 0.825961f, 0.830876f, 0.835791f, 0.840706f, 0.845621f, 0.850536f, 
0.854558f, 0.859473f, 0.863941f, 0.868409f, 0.872878f, 0.877346f, 0.881814f, 0.886282f, 
0.890751f, 0.894325f, 0.897900f, 0.901475f, 0.905049f, 0.908624f, 0.912198f, 0.918007f, 
0.921582f, 0.925156f, 0.928731f, 0.932306f, 0.935880f, 0.937668f, 0.939455f, 0.941242f, 
0.943030f, 0.946604f, 0.950179f, 0.953753f, 0.957328f, 0.960903f, 0.964477f, 0.968052f, 
0.971626f, 0.975201f, 0.978776f, 0.982350f, 0.985925f, 0.989500f, 0.993074f, 0.996649f, 
1.000223f, 
};

