// David Eberly, Geometric Tools, Redmond WA 98052
// Copyright (c) 1998-2025
// Distributed under the Boost Software License, Version 1.0.
// https://www.boost.org/LICENSE_1_0.txt
// https://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
// File Version: 8.0.2025.05.10

#include <Graphics/GTGraphicsPCH.h>
#include <Graphics/FontArialW400H14.h>
using namespace gte;

FontArialW400H14::FontArialW400H14(std::shared_ptr<ProgramFactory> const& factory, int32_t maxMessageLength)
    :
    Font(factory, msWidth, msHeight, reinterpret_cast<uint8_t const*>(msTexels), msCharacterData, maxMessageLength)
{
}

int32_t FontArialW400H14::msWidth = 1883;
int32_t FontArialW400H14::msHeight = 14;

uint8_t FontArialW400H14::msTexels[26362] =
{
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 
255, 255, 255,   0,   0,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255,   0,   0, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255,   0, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255,   0, 255,   0, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0, 255,   0, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
  0, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 
255, 255,   0, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0,   0, 255, 255, 
255,   0,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0, 
  0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 
255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
  0, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0,   0, 255,   0, 
255, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0,   0, 255,   0, 255, 255, 
255,   0,   0, 255,   0, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0, 
  0,   0, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0,   0, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0, 
  0, 255,   0, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0,   0, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255,   0, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255,   0,   0, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 
255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255,   0, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255, 
  0,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255,   0,   0, 
255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255, 
  0, 255, 255,   0,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 
255,   0, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
  0, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0,   0,   0, 255, 255,   0, 255,   0, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 
255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0,   0, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
  0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255,   0,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255,   0, 255,   0, 255, 255,   0, 255, 255,   0, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
  0, 255,   0, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255,   0,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255,   0, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
  0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 
  0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255, 
255,   0, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
  0,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 
  0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0, 
  0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255,   0, 255,   0, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255, 
255,   0,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
  0, 255, 255, 255,   0, 255, 255,   0,   0, 255,   0, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 
255, 255,   0, 255, 255,   0, 255, 255,   0,   0, 255, 255,   0,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0,   0,   0, 255,   0, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255,   0, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255,   0,   0,   0, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 
  0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 255, 
  0, 255, 255,   0, 255, 255,   0, 255, 255,   0,   0,   0,   0, 255, 255,   0, 
255, 255,   0, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255, 
  0,   0,   0,   0,   0, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 255,   0, 255,   0, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 
255, 255,   0, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255,   0, 255,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255,   0,   0, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
  0,   0,   0, 255, 255, 255,   0,   0, 255,   0, 255, 255,   0, 255,   0,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 255,   0,   0, 255, 255, 255, 
255,   0,   0, 255,   0, 255, 255,   0, 255,   0, 255, 255, 255,   0,   0,   0, 
255, 255,   0,   0,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0,   0, 
  0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0,   0,   0, 255,   0, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0,   0,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255,   0,   0,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255,   0, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0,   0, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0, 255,   0,   0,   0, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 255,   0, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0,   0,   0,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 
255, 255,   0, 255,   0, 255,   0, 255, 255,   0, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255,   0,   0, 255, 255, 255,   0,   0, 255, 255,   0,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 
255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0,   0, 
  0, 255, 255, 255, 255,   0,   0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255,   0,   0,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0,   0, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
  0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 
255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0, 255, 255, 255, 
255, 255,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 
255, 255,   0,   0,   0,   0, 255, 255, 255,   0,   0,   0,   0,   0, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255,   0,   0, 
  0,   0,   0, 255, 255,   0,   0, 255, 255,   0, 255, 255, 255,   0,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 
  0,   0,   0, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0,   0,   0, 
  0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0, 
  0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255,   0,   0,   0, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
  0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255,   0,   0,   0, 255, 
255, 255,   0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255, 
  0,   0,   0,   0,   0, 255, 255,   0,   0,   0,   0,   0, 255, 255,   0, 255, 
255,   0, 255, 255,   0, 255, 255,   0, 255, 255, 255,   0,   0,   0,   0, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255,   0, 
  0,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0,   0,   0, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 
  0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 255, 255,   0, 255, 255,   0, 
255,   0, 255,   0, 255, 255, 255,   0,   0,   0, 255, 255, 255,   0, 255,   0, 
255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 
255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255,   0, 255, 255, 255, 255,   0, 255, 255,   0, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
  0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 
255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0,   0,   0, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255,   0, 255, 255,   0, 255,   0, 255,   0,   0, 255,   0, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 
255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255, 255, 255,   0, 255, 255, 
255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 
  0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255, 255, 255, 255, 255, 255,   0, 
255,   0, 255, 255, 255, 255, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255, 
255,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
};

float FontArialW400H14::msCharacterData[257] =
{
0.000266f, 0.005045f, 0.009825f, 0.014604f, 0.019384f, 0.024164f, 0.028943f, 0.033723f, 
0.038502f, 0.043282f, 0.048062f, 0.052841f, 0.057621f, 0.062400f, 0.067180f, 0.071960f, 
0.076739f, 0.081519f, 0.086298f, 0.091078f, 0.095858f, 0.100637f, 0.105417f, 0.110196f, 
0.114976f, 0.119756f, 0.124535f, 0.129315f, 0.134095f, 0.138874f, 0.143654f, 0.148433f, 
0.153213f, 0.155337f, 0.156930f, 0.159586f, 0.163303f, 0.167021f, 0.172862f, 0.177111f, 
0.178704f, 0.181360f, 0.184015f, 0.186670f, 0.190388f, 0.192512f, 0.195167f, 0.197292f, 
0.199416f, 0.203133f, 0.206851f, 0.210568f, 0.214286f, 0.218003f, 0.221721f, 0.225438f, 
0.229156f, 0.232873f, 0.236591f, 0.238715f, 0.240839f, 0.244557f, 0.248274f, 0.251992f, 
0.255709f, 0.262082f, 0.266861f, 0.271110f, 0.275358f, 0.279607f, 0.283324f, 0.287042f, 
0.291822f, 0.296070f, 0.297663f, 0.300850f, 0.305098f, 0.308816f, 0.313595f, 0.317844f, 
0.322623f, 0.326341f, 0.331121f, 0.335369f, 0.339618f, 0.343335f, 0.347584f, 0.352363f, 
0.358205f, 0.362454f, 0.367233f, 0.371482f, 0.373606f, 0.375730f, 0.377854f, 0.381041f, 
0.384758f, 0.387414f, 0.391131f, 0.394849f, 0.398566f, 0.402284f, 0.406001f, 0.408656f, 
0.412374f, 0.416091f, 0.417685f, 0.419278f, 0.422464f, 0.424057f, 0.428837f, 0.432554f, 
0.436272f, 0.439989f, 0.443707f, 0.446362f, 0.450080f, 0.452204f, 0.455921f, 0.459639f, 
0.465481f, 0.469198f, 0.472916f, 0.476633f, 0.479288f, 0.480882f, 0.483537f, 0.487254f, 
0.492034f, 0.496814f, 0.501593f, 0.506373f, 0.511152f, 0.515932f, 0.520712f, 0.525491f, 
0.530271f, 0.535050f, 0.539830f, 0.544610f, 0.549389f, 0.554169f, 0.558948f, 0.563728f, 
0.568508f, 0.573287f, 0.578067f, 0.582847f, 0.587626f, 0.592406f, 0.597185f, 0.601965f, 
0.606745f, 0.611524f, 0.616304f, 0.621083f, 0.625863f, 0.630643f, 0.635422f, 0.640202f, 
0.644981f, 0.647106f, 0.648699f, 0.652416f, 0.656134f, 0.660382f, 0.664100f, 0.665693f, 
0.669411f, 0.672066f, 0.676845f, 0.679501f, 0.683218f, 0.686936f, 0.689591f, 0.694371f, 
0.698088f, 0.700743f, 0.704461f, 0.707116f, 0.709772f, 0.712427f, 0.716144f, 0.719862f, 
0.722517f, 0.725173f, 0.727828f, 0.731014f, 0.734732f, 0.740042f, 0.745884f, 0.751726f, 
0.755443f, 0.760223f, 0.765003f, 0.769782f, 0.774562f, 0.779341f, 0.784121f, 0.790494f, 
0.794742f, 0.798460f, 0.802177f, 0.805895f, 0.809612f, 0.811206f, 0.812799f, 0.814392f, 
0.815985f, 0.820765f, 0.825013f, 0.829793f, 0.834572f, 0.839352f, 0.844132f, 0.848911f, 
0.852629f, 0.857408f, 0.861657f, 0.865905f, 0.870154f, 0.874403f, 0.879182f, 0.883431f, 
0.887679f, 0.891397f, 0.895114f, 0.898832f, 0.902549f, 0.906267f, 0.909984f, 0.915826f, 
0.919543f, 0.923261f, 0.926978f, 0.930696f, 0.934413f, 0.936006f, 0.937600f, 0.939193f, 
0.940786f, 0.944503f, 0.948221f, 0.951938f, 0.955656f, 0.959373f, 0.963091f, 0.966808f, 
0.970526f, 0.974243f, 0.977961f, 0.981678f, 0.985396f, 0.989113f, 0.992831f, 0.996548f, 
1.000265f, 
};

